/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetStringParser;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1SequenceParser;
import com.enterprisedt.bouncycastle.asn1.DERIA5String;
import com.enterprisedt.bouncycastle.asn1.cms.Evidence;
import com.enterprisedt.bouncycastle.asn1.cms.MetaData;
import java.io.IOException;

public class TimeStampedDataParser {
    private ASN1Integer a;
    private DERIA5String b;
    private MetaData c;
    private ASN1OctetStringParser d;
    private Evidence e;
    private ASN1SequenceParser f;

    private TimeStampedDataParser(ASN1SequenceParser parser) throws IOException {
        this.f = parser;
        this.a = ASN1Integer.getInstance(parser.readObject());
        ASN1Encodable aSN1Encodable = parser.readObject();
        if (aSN1Encodable instanceof DERIA5String) {
            this.b = DERIA5String.getInstance(aSN1Encodable);
            aSN1Encodable = parser.readObject();
        }
        if (aSN1Encodable instanceof MetaData || aSN1Encodable instanceof ASN1SequenceParser) {
            this.c = MetaData.getInstance(aSN1Encodable.toASN1Primitive());
            aSN1Encodable = parser.readObject();
        }
        if (aSN1Encodable instanceof ASN1OctetStringParser) {
            this.d = (ASN1OctetStringParser)aSN1Encodable;
        }
    }

    public static TimeStampedDataParser getInstance(Object obj) throws IOException {
        if (obj instanceof ASN1Sequence) {
            return new TimeStampedDataParser(((ASN1Sequence)obj).parser());
        }
        if (obj instanceof ASN1SequenceParser) {
            return new TimeStampedDataParser((ASN1SequenceParser)obj);
        }
        return null;
    }

    public DERIA5String getDataUri() {
        return this.b;
    }

    public MetaData getMetaData() {
        return this.c;
    }

    public ASN1OctetStringParser getContent() {
        return this.d;
    }

    public Evidence getTemporalEvidence() throws IOException {
        if (this.e == null) {
            this.e = Evidence.getInstance(this.f.readObject().toASN1Primitive());
        }
        return this.e;
    }
}

