/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import com.enterprisedt.bouncycastle.asn1.crmf.CertRequest;
import com.enterprisedt.bouncycastle.asn1.crmf.ProofOfPossession;
import java.util.Enumeration;

public class CertReqMsg
extends ASN1Object {
    private CertRequest a;
    private ProofOfPossession b;
    private ASN1Sequence c;

    private CertReqMsg(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.a = CertRequest.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (e2 instanceof ASN1TaggedObject || e2 instanceof ProofOfPossession) {
                this.b = ProofOfPossession.getInstance(e2);
                continue;
            }
            this.c = ASN1Sequence.getInstance(e2);
        }
    }

    public static CertReqMsg getInstance(Object o2) {
        if (o2 instanceof CertReqMsg) {
            return (CertReqMsg)o2;
        }
        if (o2 != null) {
            return new CertReqMsg(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public static CertReqMsg getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertReqMsg.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public CertReqMsg(CertRequest certReq, ProofOfPossession pop, AttributeTypeAndValue[] regInfo) {
        if (certReq == null) {
            throw new IllegalArgumentException("'certReq' cannot be null");
        }
        this.a = certReq;
        this.b = pop;
        if (regInfo != null) {
            this.c = new DERSequence(regInfo);
        }
    }

    public CertRequest getCertReq() {
        return this.a;
    }

    public ProofOfPossession getPop() {
        return this.b;
    }

    public ProofOfPossession getPopo() {
        return this.b;
    }

    public AttributeTypeAndValue[] getRegInfo() {
        if (this.c == null) {
            return null;
        }
        AttributeTypeAndValue[] attributeTypeAndValueArray = new AttributeTypeAndValue[this.c.size()];
        for (int i2 = 0; i2 != attributeTypeAndValueArray.length; ++i2) {
            attributeTypeAndValueArray[i2] = AttributeTypeAndValue.getInstance(this.c.getObjectAt(i2));
        }
        return attributeTypeAndValueArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        this.a(aSN1EncodableVector, this.b);
        this.a(aSN1EncodableVector, this.c);
        return new DERSequence(aSN1EncodableVector);
    }

    private void a(ASN1EncodableVector aSN1EncodableVector, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(aSN1Encodable);
        }
    }
}

