/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.enterprisedt.bouncycastle.util.Arrays;

public class DhSigStatic
extends ASN1Object {
    private final IssuerAndSerialNumber a;
    private final ASN1OctetString b;

    public DhSigStatic(byte[] hashValue) {
        this(null, hashValue);
    }

    public DhSigStatic(IssuerAndSerialNumber issuerAndSerial, byte[] hashValue) {
        this.a = issuerAndSerial;
        this.b = new DEROctetString(Arrays.clone(hashValue));
    }

    public static DhSigStatic getInstance(Object o2) {
        if (o2 instanceof DhSigStatic) {
            return (DhSigStatic)o2;
        }
        if (o2 != null) {
            return new DhSigStatic(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private DhSigStatic(ASN1Sequence seq) {
        if (seq.size() == 1) {
            this.a = null;
            this.b = ASN1OctetString.getInstance(seq.getObjectAt(0));
        } else if (seq.size() == 2) {
            this.a = IssuerAndSerialNumber.getInstance(seq.getObjectAt(0));
            this.b = ASN1OctetString.getInstance(seq.getObjectAt(1));
        } else {
            throw new IllegalArgumentException("sequence wrong length for DhSigStatic");
        }
    }

    public IssuerAndSerialNumber getIssuerAndSerial() {
        return this.a;
    }

    public byte[] getHashValue() {
        return Arrays.clone(this.b.getOctets());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

