/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERUTF8String;
import com.enterprisedt.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;

public class EncKeyWithID
extends ASN1Object {
    private final PrivateKeyInfo a;
    private final ASN1Encodable b;

    public static EncKeyWithID getInstance(Object o2) {
        if (o2 instanceof EncKeyWithID) {
            return (EncKeyWithID)o2;
        }
        if (o2 != null) {
            return new EncKeyWithID(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private EncKeyWithID(ASN1Sequence seq) {
        this.a = PrivateKeyInfo.getInstance(seq.getObjectAt(0));
        this.b = seq.size() > 1 ? (!(seq.getObjectAt(1) instanceof DERUTF8String) ? GeneralName.getInstance(seq.getObjectAt(1)) : seq.getObjectAt(1)) : null;
    }

    public EncKeyWithID(PrivateKeyInfo privKeyInfo) {
        this.a = privKeyInfo;
        this.b = null;
    }

    public EncKeyWithID(PrivateKeyInfo privKeyInfo, DERUTF8String str) {
        this.a = privKeyInfo;
        this.b = str;
    }

    public EncKeyWithID(PrivateKeyInfo privKeyInfo, GeneralName generalName) {
        this.a = privKeyInfo;
        this.b = generalName;
    }

    public PrivateKeyInfo getPrivateKey() {
        return this.a;
    }

    public boolean hasIdentifier() {
        return this.b != null;
    }

    public boolean isIdentifierUTF8String() {
        return this.b instanceof DERUTF8String;
    }

    public ASN1Encodable getIdentifier() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

