/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.Time;
import java.util.Enumeration;

public class OptionalValidity
extends ASN1Object {
    private Time a;
    private Time b;

    private OptionalValidity(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.a = Time.getInstance(aSN1TaggedObject, true);
                continue;
            }
            this.b = Time.getInstance(aSN1TaggedObject, true);
        }
    }

    public static OptionalValidity getInstance(Object o2) {
        if (o2 instanceof OptionalValidity) {
            return (OptionalValidity)o2;
        }
        if (o2 != null) {
            return new OptionalValidity(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public OptionalValidity(Time notBefore, Time notAfter) {
        if (notBefore == null && notAfter == null) {
            throw new IllegalArgumentException("at least one of notBefore/notAfter must not be null.");
        }
        this.a = notBefore;
        this.b = notAfter;
    }

    public Time getNotBefore() {
        return this.a;
    }

    public Time getNotAfter() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.a));
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.b));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

