/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1Boolean;
import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.crmf.EncryptedKey;

public class PKIArchiveOptions
extends ASN1Object
implements ASN1Choice {
    public static final int encryptedPrivKey = 0;
    public static final int keyGenParameters = 1;
    public static final int archiveRemGenPrivKey = 2;
    private ASN1Encodable a;

    public static PKIArchiveOptions getInstance(Object o2) {
        if (o2 == null || o2 instanceof PKIArchiveOptions) {
            return (PKIArchiveOptions)o2;
        }
        if (o2 instanceof ASN1TaggedObject) {
            return new PKIArchiveOptions((ASN1TaggedObject)o2);
        }
        throw new IllegalArgumentException("unknown object: " + o2);
    }

    private PKIArchiveOptions(ASN1TaggedObject tagged) {
        switch (tagged.getTagNo()) {
            case 0: {
                this.a = EncryptedKey.getInstance(tagged.getObject());
                break;
            }
            case 1: {
                this.a = ASN1OctetString.getInstance(tagged, false);
                break;
            }
            case 2: {
                this.a = ASN1Boolean.getInstance(tagged, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag number: " + tagged.getTagNo());
            }
        }
    }

    public PKIArchiveOptions(EncryptedKey encKey) {
        this.a = encKey;
    }

    public PKIArchiveOptions(ASN1OctetString keyGenParameters) {
        this.a = keyGenParameters;
    }

    public PKIArchiveOptions(boolean archiveRemGenPrivKey) {
        this.a = ASN1Boolean.getInstance(archiveRemGenPrivKey);
    }

    public int getType() {
        if (this.a instanceof EncryptedKey) {
            return 0;
        }
        if (this.a instanceof ASN1OctetString) {
            return 1;
        }
        return 2;
    }

    public ASN1Encodable getValue() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a instanceof EncryptedKey) {
            return new DERTaggedObject(true, 0, this.a);
        }
        if (this.a instanceof ASN1OctetString) {
            return new DERTaggedObject(false, 1, this.a);
        }
        return new DERTaggedObject(false, 2, this.a);
    }
}

