/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.cmp.PBMParameter;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PKMACValue
extends ASN1Object {
    private AlgorithmIdentifier a;
    private DERBitString b;

    private PKMACValue(ASN1Sequence seq) {
        this.a = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        this.b = DERBitString.getInstance(seq.getObjectAt(1));
    }

    public static PKMACValue getInstance(Object o2) {
        if (o2 instanceof PKMACValue) {
            return (PKMACValue)o2;
        }
        if (o2 != null) {
            return new PKMACValue(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public static PKMACValue getInstance(ASN1TaggedObject obj, boolean isExplicit) {
        return PKMACValue.getInstance(ASN1Sequence.getInstance(obj, isExplicit));
    }

    public PKMACValue(PBMParameter params, DERBitString value) {
        this(new AlgorithmIdentifier(CMPObjectIdentifiers.passwordBasedMac, params), value);
    }

    public PKMACValue(AlgorithmIdentifier aid, DERBitString value) {
        this.a = aid;
        this.b = value;
    }

    public AlgorithmIdentifier getAlgId() {
        return this.a;
    }

    public DERBitString getValue() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

