/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cms.EnvelopedData;
import com.enterprisedt.bouncycastle.asn1.crmf.PKMACValue;
import com.enterprisedt.bouncycastle.asn1.crmf.SubsequentMessage;

public class POPOPrivKey
extends ASN1Object
implements ASN1Choice {
    public static final int thisMessage = 0;
    public static final int subsequentMessage = 1;
    public static final int dhMAC = 2;
    public static final int agreeMAC = 3;
    public static final int encryptedKey = 4;
    private int a;
    private ASN1Encodable b;

    private POPOPrivKey(ASN1TaggedObject obj) {
        this.a = obj.getTagNo();
        switch (this.a) {
            case 0: {
                this.b = DERBitString.getInstance(obj, false);
                break;
            }
            case 1: {
                this.b = SubsequentMessage.valueOf(ASN1Integer.getInstance(obj, false).getValue().intValue());
                break;
            }
            case 2: {
                this.b = DERBitString.getInstance(obj, false);
                break;
            }
            case 3: {
                this.b = PKMACValue.getInstance(obj, false);
                break;
            }
            case 4: {
                this.b = EnvelopedData.getInstance(obj, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag in POPOPrivKey");
            }
        }
    }

    public static POPOPrivKey getInstance(Object obj) {
        if (obj instanceof POPOPrivKey) {
            return (POPOPrivKey)obj;
        }
        if (obj != null) {
            return new POPOPrivKey(ASN1TaggedObject.getInstance(obj));
        }
        return null;
    }

    public static POPOPrivKey getInstance(ASN1TaggedObject obj, boolean explicit) {
        return POPOPrivKey.getInstance(ASN1TaggedObject.getInstance(obj, explicit));
    }

    public POPOPrivKey(PKMACValue agreeMac) {
        this.a = 3;
        this.b = agreeMac;
    }

    public POPOPrivKey(SubsequentMessage msg) {
        this.a = 1;
        this.b = msg;
    }

    public int getType() {
        return this.a;
    }

    public ASN1Encodable getValue() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(false, this.a, this.b);
    }
}

