/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.crmf.POPOSigningKeyInput;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class POPOSigningKey
extends ASN1Object {
    private POPOSigningKeyInput a;
    private AlgorithmIdentifier b;
    private DERBitString c;

    private POPOSigningKey(ASN1Sequence seq) {
        int n2 = 0;
        if (seq.getObjectAt(n2) instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject;
            if ((aSN1TaggedObject = (ASN1TaggedObject)seq.getObjectAt(n2++)).getTagNo() != 0) {
                throw new IllegalArgumentException("Unknown POPOSigningKeyInput tag: " + aSN1TaggedObject.getTagNo());
            }
            this.a = POPOSigningKeyInput.getInstance(aSN1TaggedObject.getObject());
        }
        this.b = AlgorithmIdentifier.getInstance(seq.getObjectAt(n2++));
        this.c = DERBitString.getInstance(seq.getObjectAt(n2));
    }

    public static POPOSigningKey getInstance(Object o2) {
        if (o2 instanceof POPOSigningKey) {
            return (POPOSigningKey)o2;
        }
        if (o2 != null) {
            return new POPOSigningKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public static POPOSigningKey getInstance(ASN1TaggedObject obj, boolean explicit) {
        return POPOSigningKey.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public POPOSigningKey(POPOSigningKeyInput poposkIn, AlgorithmIdentifier aid, DERBitString signature) {
        this.a = poposkIn;
        this.b = aid;
        this.c = signature;
    }

    public POPOSigningKeyInput getPoposkInput() {
        return this.a;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.b;
    }

    public DERBitString getSignature() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.a));
        }
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

