/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERNull;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.crmf.POPOPrivKey;
import com.enterprisedt.bouncycastle.asn1.crmf.POPOSigningKey;

public class ProofOfPossession
extends ASN1Object
implements ASN1Choice {
    public static final int TYPE_RA_VERIFIED = 0;
    public static final int TYPE_SIGNING_KEY = 1;
    public static final int TYPE_KEY_ENCIPHERMENT = 2;
    public static final int TYPE_KEY_AGREEMENT = 3;
    private int a;
    private ASN1Encodable b;

    private ProofOfPossession(ASN1TaggedObject tagged) {
        this.a = tagged.getTagNo();
        switch (this.a) {
            case 0: {
                this.b = DERNull.INSTANCE;
                break;
            }
            case 1: {
                this.b = POPOSigningKey.getInstance(tagged, false);
                break;
            }
            case 2: 
            case 3: {
                this.b = POPOPrivKey.getInstance(tagged, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag: " + this.a);
            }
        }
    }

    public static ProofOfPossession getInstance(Object o2) {
        if (o2 == null || o2 instanceof ProofOfPossession) {
            return (ProofOfPossession)o2;
        }
        if (o2 instanceof ASN1TaggedObject) {
            return new ProofOfPossession((ASN1TaggedObject)o2);
        }
        throw new IllegalArgumentException("Invalid object: " + o2.getClass().getName());
    }

    public ProofOfPossession() {
        this.a = 0;
        this.b = DERNull.INSTANCE;
    }

    public ProofOfPossession(POPOSigningKey poposk) {
        this.a = 1;
        this.b = poposk;
    }

    public ProofOfPossession(int type, POPOPrivKey privkey) {
        this.a = type;
        this.b = privkey;
    }

    public int getType() {
        return this.a;
    }

    public ASN1Encodable getObject() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(false, this.a, this.b);
    }
}

