/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cryptopro;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.util.Arrays;

public class Gost2814789KeyWrapParameters
extends ASN1Object {
    private final ASN1ObjectIdentifier a;
    private final byte[] b;

    private Gost2814789KeyWrapParameters(ASN1Sequence seq) {
        if (seq.size() == 2) {
            this.a = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
            this.b = ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets();
        } else if (seq.size() == 1) {
            this.a = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
            this.b = null;
        } else {
            throw new IllegalArgumentException("unknown sequence length: " + seq.size());
        }
    }

    public static Gost2814789KeyWrapParameters getInstance(Object obj) {
        if (obj instanceof Gost2814789KeyWrapParameters) {
            return (Gost2814789KeyWrapParameters)obj;
        }
        if (obj != null) {
            return new Gost2814789KeyWrapParameters(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public Gost2814789KeyWrapParameters(ASN1ObjectIdentifier encryptionParamSet) {
        this(encryptionParamSet, null);
    }

    public Gost2814789KeyWrapParameters(ASN1ObjectIdentifier encryptionParamSet, byte[] ukm) {
        this.a = encryptionParamSet;
        this.b = Arrays.clone(ukm);
    }

    public ASN1ObjectIdentifier getEncryptionParamSet() {
        return this.a;
    }

    public byte[] getUkm() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DEROctetString(this.b));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

