/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cryptopro;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.util.Arrays;

public class GostR3410TransportParameters
extends ASN1Object {
    private final ASN1ObjectIdentifier a;
    private final SubjectPublicKeyInfo b;
    private final byte[] c;

    public GostR3410TransportParameters(ASN1ObjectIdentifier encryptionParamSet, SubjectPublicKeyInfo ephemeralPublicKey, byte[] ukm) {
        this.a = encryptionParamSet;
        this.b = ephemeralPublicKey;
        this.c = Arrays.clone(ukm);
    }

    private GostR3410TransportParameters(ASN1Sequence seq) {
        if (seq.size() == 2) {
            this.a = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
            this.c = ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets();
            this.b = null;
        } else if (seq.size() == 3) {
            this.a = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
            this.b = SubjectPublicKeyInfo.getInstance(ASN1TaggedObject.getInstance(seq.getObjectAt(1)), false);
            this.c = ASN1OctetString.getInstance(seq.getObjectAt(2)).getOctets();
        } else {
            throw new IllegalArgumentException("unknown sequence length: " + seq.size());
        }
    }

    public static GostR3410TransportParameters getInstance(Object obj) {
        if (obj instanceof GostR3410TransportParameters) {
            return (GostR3410TransportParameters)obj;
        }
        if (obj != null) {
            return new GostR3410TransportParameters(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static GostR3410TransportParameters getInstance(ASN1TaggedObject obj, boolean explicit) {
        return new GostR3410TransportParameters(ASN1Sequence.getInstance(obj, explicit));
    }

    public ASN1ObjectIdentifier getEncryptionParamSet() {
        return this.a;
    }

    public SubjectPublicKeyInfo getEphemeralPublicKey() {
        return this.b;
    }

    public byte[] getUkm() {
        return Arrays.clone(this.c);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.b));
        }
        aSN1EncodableVector.add(new DEROctetString(this.c));
        return new DERSequence(aSN1EncodableVector);
    }
}

