/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.dvcs;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.dvcs.DVCSRequestInformation;
import com.enterprisedt.bouncycastle.asn1.dvcs.Data;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;

public class DVCSRequest
extends ASN1Object {
    private DVCSRequestInformation a;
    private Data b;
    private GeneralName c;

    public DVCSRequest(DVCSRequestInformation requestInformation, Data data) {
        this(requestInformation, data, null);
    }

    public DVCSRequest(DVCSRequestInformation requestInformation, Data data, GeneralName transactionIdentifier) {
        this.a = requestInformation;
        this.b = data;
        this.c = transactionIdentifier;
    }

    private DVCSRequest(ASN1Sequence seq) {
        this.a = DVCSRequestInformation.getInstance(seq.getObjectAt(0));
        this.b = Data.getInstance(seq.getObjectAt(1));
        if (seq.size() > 2) {
            this.c = GeneralName.getInstance(seq.getObjectAt(2));
        }
    }

    public static DVCSRequest getInstance(Object obj) {
        if (obj instanceof DVCSRequest) {
            return (DVCSRequest)obj;
        }
        if (obj != null) {
            return new DVCSRequest(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static DVCSRequest getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DVCSRequest.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        return "DVCSRequest {\nrequestInformation: " + this.a + "\ndata: " + this.b + "\n" + (this.c != null ? "transactionIdentifier: " + this.c + "\n" : "") + "}\n";
    }

    public Data getData() {
        return this.b;
    }

    public DVCSRequestInformation getRequestInformation() {
        return this.a;
    }

    public GeneralName getTransactionIdentifier() {
        return this.c;
    }
}

