/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.dvcs;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.dvcs.TargetEtcChain;
import com.enterprisedt.bouncycastle.asn1.x509.DigestInfo;

public class Data
extends ASN1Object
implements ASN1Choice {
    private ASN1OctetString a;
    private DigestInfo b;
    private ASN1Sequence c;

    public Data(byte[] messageBytes) {
        this.a = new DEROctetString(messageBytes);
    }

    public Data(ASN1OctetString message) {
        this.a = message;
    }

    public Data(DigestInfo messageImprint) {
        this.b = messageImprint;
    }

    public Data(TargetEtcChain cert) {
        this.c = new DERSequence(cert);
    }

    public Data(TargetEtcChain[] certs) {
        this.c = new DERSequence(certs);
    }

    private Data(ASN1Sequence certs) {
        this.c = certs;
    }

    public static Data getInstance(Object obj) {
        if (obj instanceof Data) {
            return (Data)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new Data((ASN1OctetString)obj);
        }
        if (obj instanceof ASN1Sequence) {
            return new Data(DigestInfo.getInstance(obj));
        }
        if (obj instanceof ASN1TaggedObject) {
            return new Data(ASN1Sequence.getInstance((ASN1TaggedObject)obj, false));
        }
        throw new IllegalArgumentException("Unknown object submitted to getInstance: " + obj.getClass().getName());
    }

    public static Data getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Data.getInstance(obj.getObject());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a != null) {
            return this.a.toASN1Primitive();
        }
        if (this.b != null) {
            return this.b.toASN1Primitive();
        }
        return new DERTaggedObject(false, 0, this.c);
    }

    public String toString() {
        if (this.a != null) {
            return "Data {\n" + this.a + "}\n";
        }
        if (this.b != null) {
            return "Data {\n" + this.b + "}\n";
        }
        return "Data {\n" + this.c + "}\n";
    }

    public ASN1OctetString getMessage() {
        return this.a;
    }

    public DigestInfo getMessageImprint() {
        return this.b;
    }

    public TargetEtcChain[] getCerts() {
        if (this.c == null) {
            return null;
        }
        TargetEtcChain[] targetEtcChainArray = new TargetEtcChain[this.c.size()];
        for (int i2 = 0; i2 != targetEtcChainArray.length; ++i2) {
            targetEtcChainArray[i2] = TargetEtcChain.getInstance(this.c.getObjectAt(i2));
        }
        return targetEtcChainArray;
    }
}

