/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.eac;

import com.enterprisedt.bouncycastle.asn1.ASN1ApplicationSpecific;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1InputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.DERApplicationSpecific;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import com.enterprisedt.bouncycastle.asn1.eac.CertificateHolderReference;
import com.enterprisedt.bouncycastle.asn1.eac.CertificationAuthorityReference;
import com.enterprisedt.bouncycastle.asn1.eac.EACTags;
import com.enterprisedt.bouncycastle.asn1.eac.PackedDate;
import com.enterprisedt.bouncycastle.asn1.eac.PublicKeyDataObject;
import java.io.IOException;

public class CertificateBody
extends ASN1Object {
    private DERApplicationSpecific a;
    private DERApplicationSpecific b;
    private PublicKeyDataObject c;
    private DERApplicationSpecific d;
    private CertificateHolderAuthorization e;
    private DERApplicationSpecific f;
    private DERApplicationSpecific g;
    private int h = 0;
    public static final int profileType = 127;
    public static final int requestType = 13;

    private void a(ASN1ApplicationSpecific aSN1ApplicationSpecific) throws IOException {
        ASN1Primitive aSN1Primitive;
        if (aSN1ApplicationSpecific.getApplicationTag() != 78) {
            throw new IOException("Bad tag : not an iso7816 CERTIFICATE_CONTENT_TEMPLATE");
        }
        byte[] byArray = aSN1ApplicationSpecific.getContents();
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        block9: while ((aSN1Primitive = aSN1InputStream.readObject()) != null) {
            if (!(aSN1Primitive instanceof DERApplicationSpecific)) {
                throw new IOException("Not a valid iso7816 content : not a DERApplicationSpecific Object :" + EACTags.encodeTag(aSN1ApplicationSpecific) + aSN1Primitive.getClass());
            }
            DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)aSN1Primitive;
            switch (dERApplicationSpecific.getApplicationTag()) {
                case 41: {
                    this.a(dERApplicationSpecific);
                    continue block9;
                }
                case 2: {
                    this.c(dERApplicationSpecific);
                    continue block9;
                }
                case 73: {
                    this.a(PublicKeyDataObject.getInstance(dERApplicationSpecific.getObject(16)));
                    continue block9;
                }
                case 32: {
                    this.b(dERApplicationSpecific);
                    continue block9;
                }
                case 76: {
                    this.a(new CertificateHolderAuthorization(dERApplicationSpecific));
                    continue block9;
                }
                case 37: {
                    this.d(dERApplicationSpecific);
                    continue block9;
                }
                case 36: {
                    this.e(dERApplicationSpecific);
                    continue block9;
                }
            }
            this.h = 0;
            throw new IOException("Not a valid iso7816 DERApplicationSpecific tag " + dERApplicationSpecific.getApplicationTag());
        }
        aSN1InputStream.close();
    }

    public CertificateBody(DERApplicationSpecific certificateProfileIdentifier, CertificationAuthorityReference certificationAuthorityReference, PublicKeyDataObject publicKey, CertificateHolderReference certificateHolderReference, CertificateHolderAuthorization certificateHolderAuthorization, PackedDate certificateEffectiveDate, PackedDate certificateExpirationDate) {
        this.a(certificateProfileIdentifier);
        this.c(new DERApplicationSpecific(2, certificationAuthorityReference.getEncoded()));
        this.a(publicKey);
        this.b(new DERApplicationSpecific(32, certificateHolderReference.getEncoded()));
        this.a(certificateHolderAuthorization);
        try {
            this.d(new DERApplicationSpecific(false, 37, new DEROctetString(certificateEffectiveDate.getEncoding())));
            this.e(new DERApplicationSpecific(false, 36, new DEROctetString(certificateExpirationDate.getEncoding())));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("unable to encode dates: " + iOException.getMessage());
        }
    }

    private CertificateBody(ASN1ApplicationSpecific obj) throws IOException {
        this.a(obj);
    }

    private ASN1Primitive a() throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(new DERApplicationSpecific(false, 73, this.c));
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        aSN1EncodableVector.add(this.f);
        aSN1EncodableVector.add(this.g);
        return new DERApplicationSpecific(78, aSN1EncodableVector);
    }

    private void a(DERApplicationSpecific dERApplicationSpecific) throws IllegalArgumentException {
        if (dERApplicationSpecific.getApplicationTag() == 41) {
            this.a = dERApplicationSpecific;
            this.h |= 1;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.INTERCHANGE_PROFILE tag :" + EACTags.encodeTag(dERApplicationSpecific));
        }
    }

    private void b(DERApplicationSpecific dERApplicationSpecific) throws IllegalArgumentException {
        if (dERApplicationSpecific.getApplicationTag() == 32) {
            this.d = dERApplicationSpecific;
            this.h |= 8;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.CARDHOLDER_NAME tag");
        }
    }

    private void c(DERApplicationSpecific dERApplicationSpecific) throws IllegalArgumentException {
        if (dERApplicationSpecific.getApplicationTag() == 2) {
            this.b = dERApplicationSpecific;
            this.h |= 2;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.ISSUER_IDENTIFICATION_NUMBER tag");
        }
    }

    private void a(PublicKeyDataObject publicKeyDataObject) {
        this.c = PublicKeyDataObject.getInstance(publicKeyDataObject);
        this.h |= 4;
    }

    private ASN1Primitive b() throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new DERApplicationSpecific(false, 73, this.c));
        aSN1EncodableVector.add(this.d);
        return new DERApplicationSpecific(78, aSN1EncodableVector);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        try {
            if (this.h == 127) {
                return this.a();
            }
            if (this.h == 13) {
                return this.b();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return null;
    }

    public int getCertificateType() {
        return this.h;
    }

    public static CertificateBody getInstance(Object obj) throws IOException {
        if (obj instanceof CertificateBody) {
            return (CertificateBody)obj;
        }
        if (obj != null) {
            return new CertificateBody(ASN1ApplicationSpecific.getInstance(obj));
        }
        return null;
    }

    public PackedDate getCertificateEffectiveDate() {
        if ((this.h & 0x20) == 32) {
            return new PackedDate(this.f.getContents());
        }
        return null;
    }

    private void d(DERApplicationSpecific dERApplicationSpecific) throws IllegalArgumentException {
        if (dERApplicationSpecific.getApplicationTag() == 37) {
            this.f = dERApplicationSpecific;
            this.h |= 0x20;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.APPLICATION_EFFECTIVE_DATE tag :" + EACTags.encodeTag(dERApplicationSpecific));
        }
    }

    public PackedDate getCertificateExpirationDate() throws IOException {
        if ((this.h & 0x40) == 64) {
            return new PackedDate(this.g.getContents());
        }
        throw new IOException("certificate Expiration Date not set");
    }

    private void e(DERApplicationSpecific dERApplicationSpecific) throws IllegalArgumentException {
        if (dERApplicationSpecific.getApplicationTag() == 36) {
            this.g = dERApplicationSpecific;
            this.h |= 0x40;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.APPLICATION_EXPIRATION_DATE tag");
        }
    }

    public CertificateHolderAuthorization getCertificateHolderAuthorization() throws IOException {
        if ((this.h & 0x10) == 16) {
            return this.e;
        }
        throw new IOException("Certificate Holder Authorisation not set");
    }

    private void a(CertificateHolderAuthorization certificateHolderAuthorization) {
        this.e = certificateHolderAuthorization;
        this.h |= 0x10;
    }

    public CertificateHolderReference getCertificateHolderReference() {
        return new CertificateHolderReference(this.d.getContents());
    }

    public DERApplicationSpecific getCertificateProfileIdentifier() {
        return this.a;
    }

    public CertificationAuthorityReference getCertificationAuthorityReference() throws IOException {
        if ((this.h & 2) == 2) {
            return new CertificationAuthorityReference(this.b.getContents());
        }
        throw new IOException("Certification authority reference not set");
    }

    public PublicKeyDataObject getPublicKey() {
        return this.c;
    }
}

