/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ess;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.IssuerSerial;
import com.enterprisedt.bouncycastle.util.Arrays;

public class ESSCertIDv2
extends ASN1Object {
    private AlgorithmIdentifier a;
    private byte[] b;
    private IssuerSerial c;
    private static final AlgorithmIdentifier d = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);

    public static ESSCertIDv2 getInstance(Object o2) {
        if (o2 instanceof ESSCertIDv2) {
            return (ESSCertIDv2)o2;
        }
        if (o2 != null) {
            return new ESSCertIDv2(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private ESSCertIDv2(ASN1Sequence seq) {
        if (seq.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        int n2 = 0;
        this.a = seq.getObjectAt(0) instanceof ASN1OctetString ? d : AlgorithmIdentifier.getInstance(seq.getObjectAt(n2++).toASN1Primitive());
        this.b = ASN1OctetString.getInstance(seq.getObjectAt(n2++).toASN1Primitive()).getOctets();
        if (seq.size() > n2) {
            this.c = IssuerSerial.getInstance(seq.getObjectAt(n2));
        }
    }

    public ESSCertIDv2(byte[] certHash) {
        this(null, certHash, null);
    }

    public ESSCertIDv2(AlgorithmIdentifier algId, byte[] certHash) {
        this(algId, certHash, null);
    }

    public ESSCertIDv2(byte[] certHash, IssuerSerial issuerSerial) {
        this(null, certHash, issuerSerial);
    }

    public ESSCertIDv2(AlgorithmIdentifier algId, byte[] certHash, IssuerSerial issuerSerial) {
        this.a = algId == null ? d : algId;
        this.b = Arrays.clone(certHash);
        this.c = issuerSerial;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.a;
    }

    public byte[] getCertHash() {
        return Arrays.clone(this.b);
    }

    public IssuerSerial getIssuerSerial() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (!this.a.equals(d)) {
            aSN1EncodableVector.add(this.a);
        }
        aSN1EncodableVector.add(new DEROctetString(this.b).toASN1Primitive());
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

