/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ess;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.DigestInfo;
import com.enterprisedt.bouncycastle.asn1.x509.IssuerSerial;

public class OtherCertID
extends ASN1Object {
    private ASN1Encodable a;
    private IssuerSerial b;

    public static OtherCertID getInstance(Object o2) {
        if (o2 instanceof OtherCertID) {
            return (OtherCertID)o2;
        }
        if (o2 != null) {
            return new OtherCertID(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private OtherCertID(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.a = seq.getObjectAt(0).toASN1Primitive() instanceof ASN1OctetString ? ASN1OctetString.getInstance(seq.getObjectAt(0)) : DigestInfo.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.b = IssuerSerial.getInstance(seq.getObjectAt(1));
        }
    }

    public OtherCertID(AlgorithmIdentifier algId, byte[] digest) {
        this.a = new DigestInfo(algId, digest);
    }

    public OtherCertID(AlgorithmIdentifier algId, byte[] digest, IssuerSerial issuerSerial) {
        this.a = new DigestInfo(algId, digest);
        this.b = issuerSerial;
    }

    public AlgorithmIdentifier getAlgorithmHash() {
        if (this.a.toASN1Primitive() instanceof ASN1OctetString) {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        }
        return DigestInfo.getInstance(this.a).getAlgorithmId();
    }

    public byte[] getCertHash() {
        if (this.a.toASN1Primitive() instanceof ASN1OctetString) {
            return ((ASN1OctetString)this.a.toASN1Primitive()).getOctets();
        }
        return DigestInfo.getInstance(this.a).getDigest();
    }

    public IssuerSerial getIssuerSerial() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

