/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ess;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.ess.OtherCertID;
import com.enterprisedt.bouncycastle.asn1.x509.PolicyInformation;

public class OtherSigningCertificate
extends ASN1Object {
    ASN1Sequence a;
    ASN1Sequence b;

    public static OtherSigningCertificate getInstance(Object o2) {
        if (o2 instanceof OtherSigningCertificate) {
            return (OtherSigningCertificate)o2;
        }
        if (o2 != null) {
            return new OtherSigningCertificate(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private OtherSigningCertificate(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.a = ASN1Sequence.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.b = ASN1Sequence.getInstance(seq.getObjectAt(1));
        }
    }

    public OtherSigningCertificate(OtherCertID otherCertID) {
        this.a = new DERSequence(otherCertID);
    }

    public OtherCertID[] getCerts() {
        OtherCertID[] otherCertIDArray = new OtherCertID[this.a.size()];
        for (int i2 = 0; i2 != this.a.size(); ++i2) {
            otherCertIDArray[i2] = OtherCertID.getInstance(this.a.getObjectAt(i2));
        }
        return otherCertIDArray;
    }

    public PolicyInformation[] getPolicies() {
        if (this.b == null) {
            return null;
        }
        PolicyInformation[] policyInformationArray = new PolicyInformation[this.b.size()];
        for (int i2 = 0; i2 != this.b.size(); ++i2) {
            policyInformationArray[i2] = PolicyInformation.getInstance(this.b.getObjectAt(i2));
        }
        return policyInformationArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

