/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.isismtt.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Boolean;
import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERPrintableString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;

public class DeclarationOfMajority
extends ASN1Object
implements ASN1Choice {
    public static final int notYoungerThan = 0;
    public static final int fullAgeAtCountry = 1;
    public static final int dateOfBirth = 2;
    private ASN1TaggedObject a;

    public DeclarationOfMajority(int notYoungerThan) {
        this.a = new DERTaggedObject(false, 0, new ASN1Integer(notYoungerThan));
    }

    public DeclarationOfMajority(boolean fullAge, String country) {
        if (country.length() > 2) {
            throw new IllegalArgumentException("country can only be 2 characters");
        }
        if (fullAge) {
            this.a = new DERTaggedObject(false, 1, new DERSequence(new DERPrintableString(country, true)));
        } else {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(ASN1Boolean.FALSE);
            aSN1EncodableVector.add(new DERPrintableString(country, true));
            this.a = new DERTaggedObject(false, 1, new DERSequence(aSN1EncodableVector));
        }
    }

    public DeclarationOfMajority(ASN1GeneralizedTime dateOfBirth) {
        this.a = new DERTaggedObject(false, 2, dateOfBirth);
    }

    public static DeclarationOfMajority getInstance(Object obj) {
        if (obj == null || obj instanceof DeclarationOfMajority) {
            return (DeclarationOfMajority)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            return new DeclarationOfMajority((ASN1TaggedObject)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    private DeclarationOfMajority(ASN1TaggedObject o2) {
        if (o2.getTagNo() > 2) {
            throw new IllegalArgumentException("Bad tag number: " + o2.getTagNo());
        }
        this.a = o2;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }

    public int getType() {
        return this.a.getTagNo();
    }

    public int notYoungerThan() {
        if (this.a.getTagNo() != 0) {
            return -1;
        }
        return ASN1Integer.getInstance(this.a, false).getValue().intValue();
    }

    public ASN1Sequence fullAgeAtCountry() {
        if (this.a.getTagNo() != 1) {
            return null;
        }
        return ASN1Sequence.getInstance(this.a, false);
    }

    public ASN1GeneralizedTime getDateOfBirth() {
        if (this.a.getTagNo() != 2) {
            return null;
        }
        return ASN1GeneralizedTime.getInstance(this.a, false);
    }
}

