/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.isismtt.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERPrintableString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class MonetaryLimit
extends ASN1Object {
    DERPrintableString a;
    ASN1Integer b;
    ASN1Integer c;

    public static MonetaryLimit getInstance(Object obj) {
        if (obj == null || obj instanceof MonetaryLimit) {
            return (MonetaryLimit)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new MonetaryLimit(ASN1Sequence.getInstance(obj));
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    private MonetaryLimit(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration enumeration = seq.getObjects();
        this.a = DERPrintableString.getInstance(enumeration.nextElement());
        this.b = ASN1Integer.getInstance(enumeration.nextElement());
        this.c = ASN1Integer.getInstance(enumeration.nextElement());
    }

    public MonetaryLimit(String currency, int amount, int exponent) {
        this.a = new DERPrintableString(currency, true);
        this.b = new ASN1Integer(amount);
        this.c = new ASN1Integer(exponent);
    }

    public String getCurrency() {
        return this.a.getString();
    }

    public BigInteger getAmount() {
        return this.b.getValue();
    }

    public BigInteger getExponent() {
        return this.c.getValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

