/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.misc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.util.Arrays;

public class CAST5CBCParameters
extends ASN1Object {
    ASN1Integer a;
    ASN1OctetString b;

    public static CAST5CBCParameters getInstance(Object o2) {
        if (o2 instanceof CAST5CBCParameters) {
            return (CAST5CBCParameters)o2;
        }
        if (o2 != null) {
            return new CAST5CBCParameters(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public CAST5CBCParameters(byte[] iv, int keyLength) {
        this.b = new DEROctetString(Arrays.clone(iv));
        this.a = new ASN1Integer(keyLength);
    }

    public CAST5CBCParameters(ASN1Sequence seq) {
        this.b = (ASN1OctetString)seq.getObjectAt(0);
        this.a = (ASN1Integer)seq.getObjectAt(1);
    }

    public byte[] getIV() {
        return Arrays.clone(this.b.getOctets());
    }

    public int getKeyLength() {
        return this.a.getValue().intValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.a);
        return new DERSequence(aSN1EncodableVector);
    }
}

