/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.misc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class ScryptParams
extends ASN1Object {
    private final byte[] a;
    private final BigInteger b;
    private final BigInteger c;
    private final BigInteger d;
    private final BigInteger e;

    public ScryptParams(byte[] salt, int costParameter, int blockSize, int parallelizationParameter) {
        this(salt, BigInteger.valueOf(costParameter), BigInteger.valueOf(blockSize), BigInteger.valueOf(parallelizationParameter), null);
    }

    public ScryptParams(byte[] salt, int costParameter, int blockSize, int parallelizationParameter, int keyLength) {
        this(salt, BigInteger.valueOf(costParameter), BigInteger.valueOf(blockSize), BigInteger.valueOf(parallelizationParameter), BigInteger.valueOf(keyLength));
    }

    public ScryptParams(byte[] salt, BigInteger costParameter, BigInteger blockSize, BigInteger parallelizationParameter, BigInteger keyLength) {
        this.a = Arrays.clone(salt);
        this.b = costParameter;
        this.c = blockSize;
        this.d = parallelizationParameter;
        this.e = keyLength;
    }

    public static ScryptParams getInstance(Object o2) {
        if (o2 instanceof ScryptParams) {
            return (ScryptParams)o2;
        }
        if (o2 != null) {
            return new ScryptParams(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private ScryptParams(ASN1Sequence seq) {
        if (seq.size() != 4 && seq.size() != 5) {
            throw new IllegalArgumentException("invalid sequence: size = " + seq.size());
        }
        this.a = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
        this.b = ASN1Integer.getInstance(seq.getObjectAt(1)).getValue();
        this.c = ASN1Integer.getInstance(seq.getObjectAt(2)).getValue();
        this.d = ASN1Integer.getInstance(seq.getObjectAt(3)).getValue();
        this.e = seq.size() == 5 ? ASN1Integer.getInstance(seq.getObjectAt(4)).getValue() : null;
    }

    public byte[] getSalt() {
        return Arrays.clone(this.a);
    }

    public BigInteger getCostParameter() {
        return this.b;
    }

    public BigInteger getBlockSize() {
        return this.c;
    }

    public BigInteger getParallelizationParameter() {
        return this.d;
    }

    public BigInteger getKeyLength() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DEROctetString(this.a));
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        aSN1EncodableVector.add(new ASN1Integer(this.c));
        aSN1EncodableVector.add(new ASN1Integer(this.d));
        if (this.e != null) {
            aSN1EncodableVector.add(new ASN1Integer(this.e));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

