/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ocsp;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.ocsp.CertID;
import com.enterprisedt.bouncycastle.asn1.ocsp.CertStatus;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.X509Extensions;

public class SingleResponse
extends ASN1Object {
    private CertID a;
    private CertStatus b;
    private ASN1GeneralizedTime c;
    private ASN1GeneralizedTime d;
    private Extensions e;

    public SingleResponse(CertID certID, CertStatus certStatus, ASN1GeneralizedTime thisUpdate, ASN1GeneralizedTime nextUpdate, X509Extensions singleExtensions) {
        this(certID, certStatus, thisUpdate, nextUpdate, Extensions.getInstance(singleExtensions));
    }

    public SingleResponse(CertID certID, CertStatus certStatus, ASN1GeneralizedTime thisUpdate, ASN1GeneralizedTime nextUpdate, Extensions singleExtensions) {
        this.a = certID;
        this.b = certStatus;
        this.c = thisUpdate;
        this.d = nextUpdate;
        this.e = singleExtensions;
    }

    private SingleResponse(ASN1Sequence seq) {
        this.a = CertID.getInstance(seq.getObjectAt(0));
        this.b = CertStatus.getInstance(seq.getObjectAt(1));
        this.c = ASN1GeneralizedTime.getInstance(seq.getObjectAt(2));
        if (seq.size() > 4) {
            this.d = ASN1GeneralizedTime.getInstance((ASN1TaggedObject)seq.getObjectAt(3), true);
            this.e = Extensions.getInstance((ASN1TaggedObject)seq.getObjectAt(4), true);
        } else if (seq.size() > 3) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)seq.getObjectAt(3);
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.d = ASN1GeneralizedTime.getInstance(aSN1TaggedObject, true);
            } else {
                this.e = Extensions.getInstance(aSN1TaggedObject, true);
            }
        }
    }

    public static SingleResponse getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SingleResponse.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static SingleResponse getInstance(Object obj) {
        if (obj instanceof SingleResponse) {
            return (SingleResponse)obj;
        }
        if (obj != null) {
            return new SingleResponse(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public CertID getCertID() {
        return this.a;
    }

    public CertStatus getCertStatus() {
        return this.b;
    }

    public ASN1GeneralizedTime getThisUpdate() {
        return this.c;
    }

    public ASN1GeneralizedTime getNextUpdate() {
        return this.d;
    }

    public Extensions getSingleExtensions() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.d));
        }
        if (this.e != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.e));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

