/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.oiw;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class ElGamalParameter
extends ASN1Object {
    ASN1Integer a;
    ASN1Integer b;

    public ElGamalParameter(BigInteger p2, BigInteger g2) {
        this.a = new ASN1Integer(p2);
        this.b = new ASN1Integer(g2);
    }

    private ElGamalParameter(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.a = (ASN1Integer)enumeration.nextElement();
        this.b = (ASN1Integer)enumeration.nextElement();
    }

    public static ElGamalParameter getInstance(Object o2) {
        if (o2 instanceof ElGamalParameter) {
            return (ElGamalParameter)o2;
        }
        if (o2 != null) {
            return new ElGamalParameter(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public BigInteger getP() {
        return this.a.getPositiveValue();
    }

    public BigInteger getG() {
        return this.b.getPositiveValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

