/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.X509Name;
import java.math.BigInteger;

public class IssuerAndSerialNumber
extends ASN1Object {
    X500Name a;
    ASN1Integer b;

    public static IssuerAndSerialNumber getInstance(Object obj) {
        if (obj instanceof IssuerAndSerialNumber) {
            return (IssuerAndSerialNumber)obj;
        }
        if (obj != null) {
            return new IssuerAndSerialNumber(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private IssuerAndSerialNumber(ASN1Sequence seq) {
        this.a = X500Name.getInstance(seq.getObjectAt(0));
        this.b = (ASN1Integer)seq.getObjectAt(1);
    }

    public IssuerAndSerialNumber(X509Name name, BigInteger certSerialNumber) {
        this.a = X500Name.getInstance(name.toASN1Primitive());
        this.b = new ASN1Integer(certSerialNumber);
    }

    public IssuerAndSerialNumber(X509Name name, ASN1Integer certSerialNumber) {
        this.a = X500Name.getInstance(name.toASN1Primitive());
        this.b = certSerialNumber;
    }

    public IssuerAndSerialNumber(X500Name name, BigInteger certSerialNumber) {
        this.a = name;
        this.b = new ASN1Integer(certSerialNumber);
    }

    public X500Name getName() {
        return this.a;
    }

    public ASN1Integer getCertificateSerialNumber() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

