/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.DigestInfo;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class MacData
extends ASN1Object {
    private static final BigInteger d = BigInteger.valueOf(1L);
    DigestInfo a;
    byte[] b;
    BigInteger c;

    public static MacData getInstance(Object obj) {
        if (obj instanceof MacData) {
            return (MacData)obj;
        }
        if (obj != null) {
            return new MacData(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private MacData(ASN1Sequence seq) {
        this.a = DigestInfo.getInstance(seq.getObjectAt(0));
        this.b = Arrays.clone(((ASN1OctetString)seq.getObjectAt(1)).getOctets());
        this.c = seq.size() == 3 ? ((ASN1Integer)seq.getObjectAt(2)).getValue() : d;
    }

    public MacData(DigestInfo digInfo, byte[] salt, int iterationCount) {
        this.a = digInfo;
        this.b = Arrays.clone(salt);
        this.c = BigInteger.valueOf(iterationCount);
    }

    public DigestInfo getMac() {
        return this.a;
    }

    public byte[] getSalt() {
        return Arrays.clone(this.b);
    }

    public BigInteger getIterationCount() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new DEROctetString(this.b));
        if (!this.c.equals(d)) {
            aSN1EncodableVector.add(new ASN1Integer(this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

