/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.pkcs.EncryptionScheme;
import com.enterprisedt.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import com.enterprisedt.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class PBES2Parameters
extends ASN1Object
implements PKCSObjectIdentifiers {
    private KeyDerivationFunc a;
    private EncryptionScheme b;

    public static PBES2Parameters getInstance(Object obj) {
        if (obj instanceof PBES2Parameters) {
            return (PBES2Parameters)obj;
        }
        if (obj != null) {
            return new PBES2Parameters(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public PBES2Parameters(KeyDerivationFunc keyDevFunc, EncryptionScheme encScheme) {
        this.a = keyDevFunc;
        this.b = encScheme;
    }

    private PBES2Parameters(ASN1Sequence obj) {
        Enumeration enumeration = obj.getObjects();
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(((ASN1Encodable)enumeration.nextElement()).toASN1Primitive());
        this.a = aSN1Sequence.getObjectAt(0).equals(id_PBKDF2) ? new KeyDerivationFunc(id_PBKDF2, PBKDF2Params.getInstance(aSN1Sequence.getObjectAt(1))) : KeyDerivationFunc.getInstance(aSN1Sequence);
        this.b = EncryptionScheme.getInstance(enumeration.nextElement());
    }

    public KeyDerivationFunc getKeyDerivationFunc() {
        return this.a;
    }

    public EncryptionScheme getEncryptionScheme() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

