/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class SignerInfo
extends ASN1Object {
    private ASN1Integer a;
    private IssuerAndSerialNumber b;
    private AlgorithmIdentifier c;
    private ASN1Set d;
    private AlgorithmIdentifier e;
    private ASN1OctetString f;
    private ASN1Set g;

    public static SignerInfo getInstance(Object o2) {
        if (o2 instanceof SignerInfo) {
            return (SignerInfo)o2;
        }
        if (o2 instanceof ASN1Sequence) {
            return new SignerInfo((ASN1Sequence)o2);
        }
        throw new IllegalArgumentException("unknown object in factory: " + o2.getClass().getName());
    }

    public SignerInfo(ASN1Integer version, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier digAlgorithm, ASN1Set authenticatedAttributes, AlgorithmIdentifier digEncryptionAlgorithm, ASN1OctetString encryptedDigest, ASN1Set unauthenticatedAttributes) {
        this.a = version;
        this.b = issuerAndSerialNumber;
        this.c = digAlgorithm;
        this.d = authenticatedAttributes;
        this.e = digEncryptionAlgorithm;
        this.f = encryptedDigest;
        this.g = unauthenticatedAttributes;
    }

    public SignerInfo(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.a = (ASN1Integer)enumeration.nextElement();
        this.b = IssuerAndSerialNumber.getInstance(enumeration.nextElement());
        this.c = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        Object e2 = enumeration.nextElement();
        if (e2 instanceof ASN1TaggedObject) {
            this.d = ASN1Set.getInstance((ASN1TaggedObject)e2, false);
            this.e = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        } else {
            this.d = null;
            this.e = AlgorithmIdentifier.getInstance(e2);
        }
        this.f = DEROctetString.getInstance(enumeration.nextElement());
        this.g = enumeration.hasMoreElements() ? ASN1Set.getInstance((ASN1TaggedObject)enumeration.nextElement(), false) : null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.b;
    }

    public ASN1Set getAuthenticatedAttributes() {
        return this.d;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.c;
    }

    public ASN1OctetString getEncryptedDigest() {
        return this.f;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return this.e;
    }

    public ASN1Set getUnauthenticatedAttributes() {
        return this.g;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.d));
        }
        aSN1EncodableVector.add(this.e);
        aSN1EncodableVector.add(this.f);
        if (this.g != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.g));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

