/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.tsp;

import com.enterprisedt.bouncycastle.asn1.ASN1Boolean;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.tsp.Accuracy;
import com.enterprisedt.bouncycastle.asn1.tsp.MessageImprint;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import java.util.Enumeration;

public class TSTInfo
extends ASN1Object {
    private ASN1Integer a;
    private ASN1ObjectIdentifier b;
    private MessageImprint c;
    private ASN1Integer d;
    private ASN1GeneralizedTime e;
    private Accuracy f;
    private ASN1Boolean g;
    private ASN1Integer h;
    private GeneralName i;
    private Extensions j;

    public static TSTInfo getInstance(Object o2) {
        if (o2 instanceof TSTInfo) {
            return (TSTInfo)o2;
        }
        if (o2 != null) {
            return new TSTInfo(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private TSTInfo(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.a = ASN1Integer.getInstance(enumeration.nextElement());
        this.b = ASN1ObjectIdentifier.getInstance(enumeration.nextElement());
        this.c = MessageImprint.getInstance(enumeration.nextElement());
        this.d = ASN1Integer.getInstance(enumeration.nextElement());
        this.e = ASN1GeneralizedTime.getInstance(enumeration.nextElement());
        this.g = ASN1Boolean.getInstance(false);
        while (enumeration.hasMoreElements()) {
            ASN1Object aSN1Object = (ASN1Object)enumeration.nextElement();
            if (aSN1Object instanceof ASN1TaggedObject) {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Object;
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        this.i = GeneralName.getInstance(aSN1TaggedObject, true);
                        break;
                    }
                    case 1: {
                        this.j = Extensions.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown tag value " + aSN1TaggedObject.getTagNo());
                    }
                }
                continue;
            }
            if (aSN1Object instanceof ASN1Sequence || aSN1Object instanceof Accuracy) {
                this.f = Accuracy.getInstance(aSN1Object);
                continue;
            }
            if (aSN1Object instanceof ASN1Boolean) {
                this.g = ASN1Boolean.getInstance(aSN1Object);
                continue;
            }
            if (!(aSN1Object instanceof ASN1Integer)) continue;
            this.h = ASN1Integer.getInstance(aSN1Object);
        }
    }

    public TSTInfo(ASN1ObjectIdentifier tsaPolicyId, MessageImprint messageImprint, ASN1Integer serialNumber, ASN1GeneralizedTime genTime, Accuracy accuracy, ASN1Boolean ordering, ASN1Integer nonce, GeneralName tsa, Extensions extensions) {
        this.a = new ASN1Integer(1L);
        this.b = tsaPolicyId;
        this.c = messageImprint;
        this.d = serialNumber;
        this.e = genTime;
        this.f = accuracy;
        this.g = ordering;
        this.h = nonce;
        this.i = tsa;
        this.j = extensions;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public MessageImprint getMessageImprint() {
        return this.c;
    }

    public ASN1ObjectIdentifier getPolicy() {
        return this.b;
    }

    public ASN1Integer getSerialNumber() {
        return this.d;
    }

    public Accuracy getAccuracy() {
        return this.f;
    }

    public ASN1GeneralizedTime getGenTime() {
        return this.e;
    }

    public ASN1Boolean getOrdering() {
        return this.g;
    }

    public ASN1Integer getNonce() {
        return this.h;
    }

    public GeneralName getTsa() {
        return this.i;
    }

    public Extensions getExtensions() {
        return this.j;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        if (this.f != null) {
            aSN1EncodableVector.add(this.f);
        }
        if (this.g != null && this.g.isTrue()) {
            aSN1EncodableVector.add(this.g);
        }
        if (this.h != null) {
            aSN1EncodableVector.add(this.h);
        }
        if (this.i != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.i));
        }
        if (this.j != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.j));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

