/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.tsp;

import com.enterprisedt.bouncycastle.asn1.ASN1Boolean;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.tsp.MessageImprint;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;

public class TimeStampReq
extends ASN1Object {
    ASN1Integer a;
    MessageImprint b;
    ASN1ObjectIdentifier c;
    ASN1Integer d;
    ASN1Boolean e;
    Extensions f;

    public static TimeStampReq getInstance(Object o2) {
        if (o2 instanceof TimeStampReq) {
            return (TimeStampReq)o2;
        }
        if (o2 != null) {
            return new TimeStampReq(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private TimeStampReq(ASN1Sequence seq) {
        int n2 = seq.size();
        int n3 = 0;
        this.a = ASN1Integer.getInstance(seq.getObjectAt(n3));
        this.b = MessageImprint.getInstance(seq.getObjectAt(++n3));
        for (int i2 = ++n3; i2 < n2; ++i2) {
            ASN1TaggedObject aSN1TaggedObject;
            if (seq.getObjectAt(i2) instanceof ASN1ObjectIdentifier) {
                this.c = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(i2));
                continue;
            }
            if (seq.getObjectAt(i2) instanceof ASN1Integer) {
                this.d = ASN1Integer.getInstance(seq.getObjectAt(i2));
                continue;
            }
            if (seq.getObjectAt(i2) instanceof ASN1Boolean) {
                this.e = ASN1Boolean.getInstance(seq.getObjectAt(i2));
                continue;
            }
            if (!(seq.getObjectAt(i2) instanceof ASN1TaggedObject) || (aSN1TaggedObject = (ASN1TaggedObject)seq.getObjectAt(i2)).getTagNo() != 0) continue;
            this.f = Extensions.getInstance(aSN1TaggedObject, false);
        }
    }

    public TimeStampReq(MessageImprint messageImprint, ASN1ObjectIdentifier tsaPolicy, ASN1Integer nonce, ASN1Boolean certReq, Extensions extensions) {
        this.a = new ASN1Integer(1L);
        this.b = messageImprint;
        this.c = tsaPolicy;
        this.d = nonce;
        this.e = certReq;
        this.f = extensions;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public MessageImprint getMessageImprint() {
        return this.b;
    }

    public ASN1ObjectIdentifier getReqPolicy() {
        return this.c;
    }

    public ASN1Integer getNonce() {
        return this.d;
    }

    public ASN1Boolean getCertReq() {
        return this.e;
    }

    public Extensions getExtensions() {
        return this.f;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        if (this.e != null && this.e.isTrue()) {
            aSN1EncodableVector.add(this.e);
        }
        if (this.f != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.f));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

