/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x500;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.enterprisedt.bouncycastle.asn1.x500.RDN;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x500.X500NameStyle;
import com.enterprisedt.bouncycastle.asn1.x500.style.BCStyle;
import java.util.Vector;

public class X500NameBuilder {
    private X500NameStyle a;
    private Vector b = new Vector();

    public X500NameBuilder() {
        this(BCStyle.INSTANCE);
    }

    public X500NameBuilder(X500NameStyle template) {
        this.a = template;
    }

    public X500NameBuilder addRDN(ASN1ObjectIdentifier oid, String value) {
        this.addRDN(oid, this.a.stringToValue(oid, value));
        return this;
    }

    public X500NameBuilder addRDN(ASN1ObjectIdentifier oid, ASN1Encodable value) {
        this.b.addElement(new RDN(oid, value));
        return this;
    }

    public X500NameBuilder addRDN(AttributeTypeAndValue attrTAndV) {
        this.b.addElement(new RDN(attrTAndV));
        return this;
    }

    public X500NameBuilder addMultiValuedRDN(ASN1ObjectIdentifier[] oids, String[] values) {
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[values.length];
        for (int i2 = 0; i2 != aSN1EncodableArray.length; ++i2) {
            aSN1EncodableArray[i2] = this.a.stringToValue(oids[i2], values[i2]);
        }
        return this.addMultiValuedRDN(oids, aSN1EncodableArray);
    }

    public X500NameBuilder addMultiValuedRDN(ASN1ObjectIdentifier[] oids, ASN1Encodable[] values) {
        AttributeTypeAndValue[] attributeTypeAndValueArray = new AttributeTypeAndValue[oids.length];
        for (int i2 = 0; i2 != oids.length; ++i2) {
            attributeTypeAndValueArray[i2] = new AttributeTypeAndValue(oids[i2], values[i2]);
        }
        return this.addMultiValuedRDN(attributeTypeAndValueArray);
    }

    public X500NameBuilder addMultiValuedRDN(AttributeTypeAndValue[] attrTAndVs) {
        this.b.addElement(new RDN(attrTAndVs));
        return this;
    }

    public X500Name build() {
        RDN[] rDNArray = new RDN[this.b.size()];
        for (int i2 = 0; i2 != rDNArray.length; ++i2) {
            rDNArray[i2] = (RDN)this.b.elementAt(i2);
        }
        return new X500Name(this.a, rDNArray);
    }
}

