/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x500.style;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1ParsingException;
import com.enterprisedt.bouncycastle.asn1.DERUTF8String;
import com.enterprisedt.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.enterprisedt.bouncycastle.asn1.x500.RDN;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x500.X500NameStyle;
import com.enterprisedt.bouncycastle.asn1.x500.style.IETFUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AbstractX500NameStyle
implements X500NameStyle {
    public static Hashtable copyHashTable(Hashtable paramsMap) {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = paramsMap.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            hashtable.put(k2, paramsMap.get(k2));
        }
        return hashtable;
    }

    private int a(ASN1Encodable aSN1Encodable) {
        String string = IETFUtils.valueToString(aSN1Encodable);
        string = IETFUtils.canonicalize(string);
        return string.hashCode();
    }

    @Override
    public int calculateHashCode(X500Name name) {
        int n2 = 0;
        RDN[] rDNArray = name.getRDNs();
        for (int i2 = 0; i2 != rDNArray.length; ++i2) {
            if (rDNArray[i2].isMultiValued()) {
                AttributeTypeAndValue[] attributeTypeAndValueArray = rDNArray[i2].getTypesAndValues();
                for (int i3 = 0; i3 != attributeTypeAndValueArray.length; ++i3) {
                    n2 ^= attributeTypeAndValueArray[i3].getType().hashCode();
                    n2 ^= this.a(attributeTypeAndValueArray[i3].getValue());
                }
                continue;
            }
            n2 ^= rDNArray[i2].getFirst().getType().hashCode();
            n2 ^= this.a(rDNArray[i2].getFirst().getValue());
        }
        return n2;
    }

    @Override
    public ASN1Encodable stringToValue(ASN1ObjectIdentifier oid, String value) {
        if (value.length() != 0 && value.charAt(0) == '#') {
            try {
                return IETFUtils.valueFromHexString(value, 1);
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException("can't recode value for oid " + oid.getId());
            }
        }
        if (value.length() != 0 && value.charAt(0) == '\\') {
            value = value.substring(1);
        }
        return this.encodeStringValue(oid, value);
    }

    protected ASN1Encodable encodeStringValue(ASN1ObjectIdentifier oid, String value) {
        return new DERUTF8String(value);
    }

    @Override
    public boolean areEqual(X500Name name1, X500Name name2) {
        RDN[] rDNArray;
        RDN[] rDNArray2 = name1.getRDNs();
        if (rDNArray2.length != (rDNArray = name2.getRDNs()).length) {
            return false;
        }
        boolean bl = false;
        if (rDNArray2[0].getFirst() != null && rDNArray[0].getFirst() != null) {
            bl = !rDNArray2[0].getFirst().getType().equals(rDNArray[0].getFirst().getType());
        }
        for (int i2 = 0; i2 != rDNArray2.length; ++i2) {
            if (this.a(bl, rDNArray2[i2], rDNArray)) continue;
            return false;
        }
        return true;
    }

    private boolean a(boolean bl, RDN rDN, RDN[] rDNArray) {
        if (bl) {
            for (int i2 = rDNArray.length - 1; i2 >= 0; --i2) {
                if (rDNArray[i2] == null || !this.rdnAreEqual(rDN, rDNArray[i2])) continue;
                rDNArray[i2] = null;
                return true;
            }
        } else {
            for (int i3 = 0; i3 != rDNArray.length; ++i3) {
                if (rDNArray[i3] == null || !this.rdnAreEqual(rDN, rDNArray[i3])) continue;
                rDNArray[i3] = null;
                return true;
            }
        }
        return false;
    }

    protected boolean rdnAreEqual(RDN rdn1, RDN rdn2) {
        return IETFUtils.rDNAreEqual(rdn1, rdn2);
    }
}

