/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.DERSequence;

public class Attribute
extends ASN1Object {
    private ASN1ObjectIdentifier a;
    private ASN1Set b;

    public static Attribute getInstance(Object o2) {
        if (o2 instanceof Attribute) {
            return (Attribute)o2;
        }
        if (o2 != null) {
            return new Attribute(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private Attribute(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.a = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
        this.b = ASN1Set.getInstance(seq.getObjectAt(1));
    }

    public Attribute(ASN1ObjectIdentifier attrType, ASN1Set attrValues) {
        this.a = attrType;
        this.b = attrValues;
    }

    public ASN1ObjectIdentifier getAttrType() {
        return new ASN1ObjectIdentifier(this.a.getId());
    }

    public ASN1Encodable[] getAttributeValues() {
        return this.b.toArray();
    }

    public ASN1Set getAttrValues() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

