/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.AttCertIssuer;
import com.enterprisedt.bouncycastle.asn1.x509.AttCertValidityPeriod;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.Holder;

public class AttributeCertificateInfo
extends ASN1Object {
    private ASN1Integer a;
    private Holder b;
    private AttCertIssuer c;
    private AlgorithmIdentifier d;
    private ASN1Integer e;
    private AttCertValidityPeriod f;
    private ASN1Sequence g;
    private DERBitString h;
    private Extensions i;

    public static AttributeCertificateInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return AttributeCertificateInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static AttributeCertificateInfo getInstance(Object obj) {
        if (obj instanceof AttributeCertificateInfo) {
            return (AttributeCertificateInfo)obj;
        }
        if (obj != null) {
            return new AttributeCertificateInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private AttributeCertificateInfo(ASN1Sequence seq) {
        int n2;
        if (seq.size() < 6 || seq.size() > 9) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        if (seq.getObjectAt(0) instanceof ASN1Integer) {
            this.a = ASN1Integer.getInstance(seq.getObjectAt(0));
            n2 = 1;
        } else {
            this.a = new ASN1Integer(0L);
            n2 = 0;
        }
        this.b = Holder.getInstance(seq.getObjectAt(n2));
        this.c = AttCertIssuer.getInstance(seq.getObjectAt(n2 + 1));
        this.d = AlgorithmIdentifier.getInstance(seq.getObjectAt(n2 + 2));
        this.e = ASN1Integer.getInstance(seq.getObjectAt(n2 + 3));
        this.f = AttCertValidityPeriod.getInstance(seq.getObjectAt(n2 + 4));
        this.g = ASN1Sequence.getInstance(seq.getObjectAt(n2 + 5));
        for (int i2 = n2 + 6; i2 < seq.size(); ++i2) {
            ASN1Encodable aSN1Encodable = seq.getObjectAt(i2);
            if (aSN1Encodable instanceof DERBitString) {
                this.h = DERBitString.getInstance(seq.getObjectAt(i2));
                continue;
            }
            if (!(aSN1Encodable instanceof ASN1Sequence) && !(aSN1Encodable instanceof Extensions)) continue;
            this.i = Extensions.getInstance(seq.getObjectAt(i2));
        }
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public Holder getHolder() {
        return this.b;
    }

    public AttCertIssuer getIssuer() {
        return this.c;
    }

    public AlgorithmIdentifier getSignature() {
        return this.d;
    }

    public ASN1Integer getSerialNumber() {
        return this.e;
    }

    public AttCertValidityPeriod getAttrCertValidityPeriod() {
        return this.f;
    }

    public ASN1Sequence getAttributes() {
        return this.g;
    }

    public DERBitString getIssuerUniqueID() {
        return this.h;
    }

    public Extensions getExtensions() {
        return this.i;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a.getValue().intValue() != 0) {
            aSN1EncodableVector.add(this.a);
        }
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        aSN1EncodableVector.add(this.f);
        aSN1EncodableVector.add(this.g);
        if (this.h != null) {
            aSN1EncodableVector.add(this.h);
        }
        if (this.i != null) {
            aSN1EncodableVector.add(this.i);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

