/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Boolean;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.X509Extension;
import java.math.BigInteger;

public class BasicConstraints
extends ASN1Object {
    ASN1Boolean a = ASN1Boolean.getInstance(false);
    ASN1Integer b = null;

    public static BasicConstraints getInstance(ASN1TaggedObject obj, boolean explicit) {
        return BasicConstraints.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static BasicConstraints getInstance(Object obj) {
        if (obj instanceof BasicConstraints) {
            return (BasicConstraints)obj;
        }
        if (obj instanceof X509Extension) {
            return BasicConstraints.getInstance(X509Extension.convertValueToObject((X509Extension)obj));
        }
        if (obj != null) {
            return new BasicConstraints(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static BasicConstraints fromExtensions(Extensions extensions) {
        return BasicConstraints.getInstance(extensions.getExtensionParsedValue(Extension.basicConstraints));
    }

    private BasicConstraints(ASN1Sequence seq) {
        if (seq.size() == 0) {
            this.a = null;
            this.b = null;
        } else {
            if (seq.getObjectAt(0) instanceof ASN1Boolean) {
                this.a = ASN1Boolean.getInstance(seq.getObjectAt(0));
            } else {
                this.a = null;
                this.b = ASN1Integer.getInstance(seq.getObjectAt(0));
            }
            if (seq.size() > 1) {
                if (this.a != null) {
                    this.b = ASN1Integer.getInstance(seq.getObjectAt(1));
                } else {
                    throw new IllegalArgumentException("wrong sequence in constructor");
                }
            }
        }
    }

    public BasicConstraints(boolean cA) {
        this.a = cA ? ASN1Boolean.getInstance(true) : null;
        this.b = null;
    }

    public BasicConstraints(int pathLenConstraint) {
        this.a = ASN1Boolean.getInstance(true);
        this.b = new ASN1Integer(pathLenConstraint);
    }

    public boolean isCA() {
        return this.a != null && this.a.isTrue();
    }

    public BigInteger getPathLenConstraint() {
        if (this.b != null) {
            return this.b.getValue();
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        if (this.b == null) {
            if (this.a == null) {
                return "BasicConstraints: isCa(false)";
            }
            return "BasicConstraints: isCa(" + this.isCA() + ")";
        }
        return "BasicConstraints: isCa(" + this.isCA() + "), pathLenConstraint = " + this.b.getValue();
    }
}

