/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x509.TBSCertificate;
import com.enterprisedt.bouncycastle.asn1.x509.Time;

public class Certificate
extends ASN1Object {
    ASN1Sequence a;
    TBSCertificate b;
    AlgorithmIdentifier c;
    DERBitString d;

    public static Certificate getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Certificate.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static Certificate getInstance(Object obj) {
        if (obj instanceof Certificate) {
            return (Certificate)obj;
        }
        if (obj != null) {
            return new Certificate(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private Certificate(ASN1Sequence seq) {
        this.a = seq;
        if (seq.size() != 3) {
            throw new IllegalArgumentException("sequence wrong size for a certificate");
        }
        this.b = TBSCertificate.getInstance(seq.getObjectAt(0));
        this.c = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.d = DERBitString.getInstance(seq.getObjectAt(2));
    }

    public TBSCertificate getTBSCertificate() {
        return this.b;
    }

    public ASN1Integer getVersion() {
        return this.b.getVersion();
    }

    public int getVersionNumber() {
        return this.b.getVersionNumber();
    }

    public ASN1Integer getSerialNumber() {
        return this.b.getSerialNumber();
    }

    public X500Name getIssuer() {
        return this.b.getIssuer();
    }

    public Time getStartDate() {
        return this.b.getStartDate();
    }

    public Time getEndDate() {
        return this.b.getEndDate();
    }

    public X500Name getSubject() {
        return this.b.getSubject();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.b.getSubjectPublicKeyInfo();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.c;
    }

    public DERBitString getSignature() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

