/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.DistributionPointName;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralNames;
import com.enterprisedt.bouncycastle.asn1.x509.ReasonFlags;
import com.enterprisedt.bouncycastle.util.Strings;

public class DistributionPoint
extends ASN1Object {
    DistributionPointName a;
    ReasonFlags b;
    GeneralNames c;

    public static DistributionPoint getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DistributionPoint.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static DistributionPoint getInstance(Object obj) {
        if (obj == null || obj instanceof DistributionPoint) {
            return (DistributionPoint)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new DistributionPoint((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid DistributionPoint: " + obj.getClass().getName());
    }

    public DistributionPoint(ASN1Sequence seq) {
        block5: for (int i2 = 0; i2 != seq.size(); ++i2) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(seq.getObjectAt(i2));
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.a = DistributionPointName.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 1: {
                    this.b = new ReasonFlags(DERBitString.getInstance(aSN1TaggedObject, false));
                    continue block5;
                }
                case 2: {
                    this.c = GeneralNames.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown tag encountered in structure: " + aSN1TaggedObject.getTagNo());
                }
            }
        }
    }

    public DistributionPoint(DistributionPointName distributionPoint, ReasonFlags reasons, GeneralNames cRLIssuer) {
        this.a = distributionPoint;
        this.b = reasons;
        this.c = cRLIssuer;
    }

    public DistributionPointName getDistributionPoint() {
        return this.a;
    }

    public ReasonFlags getReasons() {
        return this.b;
    }

    public GeneralNames getCRLIssuer() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(0, this.a));
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.b));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        String string = Strings.lineSeparator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DistributionPoint: [");
        stringBuffer.append(string);
        if (this.a != null) {
            this.a(stringBuffer, string, "distributionPoint", this.a.toString());
        }
        if (this.b != null) {
            this.a(stringBuffer, string, "reasons", this.b.toString());
        }
        if (this.c != null) {
            this.a(stringBuffer, string, "cRLIssuer", this.c.toString());
        }
        stringBuffer.append("]");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private void a(StringBuffer stringBuffer, String string, String string2, String string3) {
        String string4 = "    ";
        stringBuffer.append(string4);
        stringBuffer.append(string2);
        stringBuffer.append(":");
        stringBuffer.append(string);
        stringBuffer.append(string4);
        stringBuffer.append(string4);
        stringBuffer.append(string3);
        stringBuffer.append(string);
    }
}

