/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class ExtensionsGenerator {
    private Hashtable a = new Hashtable();
    private Vector b = new Vector();

    public void reset() {
        this.a = new Hashtable();
        this.b = new Vector();
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean critical, ASN1Encodable value) throws IOException {
        this.addExtension(oid, critical, value.toASN1Primitive().getEncoded("DER"));
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean critical, byte[] value) {
        if (this.a.containsKey(oid)) {
            throw new IllegalArgumentException("extension " + oid + " already added");
        }
        this.b.addElement(oid);
        this.a.put(oid, new Extension(oid, critical, (ASN1OctetString)new DEROctetString(value)));
    }

    public void addExtension(Extension extension) {
        if (this.a.containsKey(extension.getExtnId())) {
            throw new IllegalArgumentException("extension " + extension.getExtnId() + " already added");
        }
        this.b.addElement(extension.getExtnId());
        this.a.put(extension.getExtnId(), extension);
    }

    public boolean isEmpty() {
        return this.b.isEmpty();
    }

    public Extensions generate() {
        Extension[] extensionArray = new Extension[this.b.size()];
        for (int i2 = 0; i2 != this.b.size(); ++i2) {
            extensionArray[i2] = (Extension)this.a.get(this.b.elementAt(i2));
        }
        return new Extensions(extensionArray);
    }
}

