/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralNames;

public class RoleSyntax
extends ASN1Object {
    private GeneralNames a;
    private GeneralName b;

    public static RoleSyntax getInstance(Object obj) {
        if (obj instanceof RoleSyntax) {
            return (RoleSyntax)obj;
        }
        if (obj != null) {
            return new RoleSyntax(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public RoleSyntax(GeneralNames roleAuthority, GeneralName roleName) {
        if (roleName == null || roleName.getTagNo() != 6 || ((ASN1String)((Object)roleName.getName())).getString().equals("")) {
            throw new IllegalArgumentException("the role name MUST be non empty and MUST use the URI option of GeneralName");
        }
        this.a = roleAuthority;
        this.b = roleName;
    }

    public RoleSyntax(GeneralName roleName) {
        this(null, roleName);
    }

    public RoleSyntax(String roleName) {
        this(new GeneralName(6, roleName == null ? "" : roleName));
    }

    private RoleSyntax(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        block4: for (int i2 = 0; i2 != seq.size(); ++i2) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(seq.getObjectAt(i2));
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.a = GeneralNames.getInstance(aSN1TaggedObject, false);
                    continue block4;
                }
                case 1: {
                    this.b = GeneralName.getInstance(aSN1TaggedObject, true);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Unknown tag in RoleSyntax");
                }
            }
        }
    }

    public GeneralNames getRoleAuthority() {
        return this.a;
    }

    public GeneralName getRoleName() {
        return this.b;
    }

    public String getRoleNameAsString() {
        ASN1String aSN1String = (ASN1String)((Object)this.b.getName());
        return aSN1String.getString();
    }

    public String[] getRoleAuthorityAsString() {
        if (this.a == null) {
            return new String[0];
        }
        GeneralName[] generalNameArray = this.a.getNames();
        String[] stringArray = new String[generalNameArray.length];
        for (int i2 = 0; i2 < generalNameArray.length; ++i2) {
            ASN1Encodable aSN1Encodable = generalNameArray[i2].getName();
            stringArray[i2] = aSN1Encodable instanceof ASN1String ? ((ASN1String)((Object)aSN1Encodable)).getString() : aSN1Encodable.toString();
        }
        return stringArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.a));
        }
        aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.b));
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Name: " + this.getRoleNameAsString() + " - Auth: ");
        if (this.a == null || this.a.getNames().length == 0) {
            stringBuffer.append("N/A");
        } else {
            String[] stringArray = this.getRoleAuthorityAsString();
            stringBuffer.append('[').append(stringArray[0]);
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                stringBuffer.append(", ").append(stringArray[i2]);
            }
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }
}

