/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;

public class Target
extends ASN1Object
implements ASN1Choice {
    public static final int targetName = 0;
    public static final int targetGroup = 1;
    private GeneralName a;
    private GeneralName b;

    public static Target getInstance(Object obj) {
        if (obj == null || obj instanceof Target) {
            return (Target)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            return new Target((ASN1TaggedObject)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass());
    }

    private Target(ASN1TaggedObject tagObj) {
        switch (tagObj.getTagNo()) {
            case 0: {
                this.a = GeneralName.getInstance(tagObj, true);
                break;
            }
            case 1: {
                this.b = GeneralName.getInstance(tagObj, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag: " + tagObj.getTagNo());
            }
        }
    }

    public Target(int type, GeneralName name) {
        this(new DERTaggedObject(type, name));
    }

    public GeneralName getTargetGroup() {
        return this.b;
    }

    public GeneralName getTargetName() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a != null) {
            return new DERTaggedObject(true, 0, this.a);
        }
        return new DERTaggedObject(true, 1, this.b);
    }
}

