/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1UTCTime;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x509.TBSCertificate;
import com.enterprisedt.bouncycastle.asn1.x509.Time;
import com.enterprisedt.bouncycastle.asn1.x509.X509Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.X509Name;

public class V3TBSCertificateGenerator {
    DERTaggedObject a = new DERTaggedObject(true, 0, new ASN1Integer(2L));
    ASN1Integer b;
    AlgorithmIdentifier c;
    X500Name d;
    Time e;
    Time f;
    X500Name g;
    SubjectPublicKeyInfo h;
    Extensions i;
    private boolean j;
    private DERBitString k;
    private DERBitString l;

    public void setSerialNumber(ASN1Integer serialNumber) {
        this.b = serialNumber;
    }

    public void setSignature(AlgorithmIdentifier signature) {
        this.c = signature;
    }

    public void setIssuer(X509Name issuer) {
        this.d = X500Name.getInstance(issuer);
    }

    public void setIssuer(X500Name issuer) {
        this.d = issuer;
    }

    public void setStartDate(ASN1UTCTime startDate) {
        this.e = new Time(startDate);
    }

    public void setStartDate(Time startDate) {
        this.e = startDate;
    }

    public void setEndDate(ASN1UTCTime endDate) {
        this.f = new Time(endDate);
    }

    public void setEndDate(Time endDate) {
        this.f = endDate;
    }

    public void setSubject(X509Name subject) {
        this.g = X500Name.getInstance(subject.toASN1Primitive());
    }

    public void setSubject(X500Name subject) {
        this.g = subject;
    }

    public void setIssuerUniqueID(DERBitString uniqueID) {
        this.k = uniqueID;
    }

    public void setSubjectUniqueID(DERBitString uniqueID) {
        this.l = uniqueID;
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo pubKeyInfo) {
        this.h = pubKeyInfo;
    }

    public void setExtensions(X509Extensions extensions) {
        this.setExtensions(Extensions.getInstance(extensions));
    }

    public void setExtensions(Extensions extensions) {
        Extension extension;
        this.i = extensions;
        if (extensions != null && (extension = extensions.getExtension(Extension.subjectAlternativeName)) != null && extension.isCritical()) {
            this.j = true;
        }
    }

    public TBSCertificate generateTBSCertificate() {
        if (this.b == null || this.c == null || this.d == null || this.e == null || this.f == null || this.g == null && !this.j || this.h == null) {
            throw new IllegalStateException("not all mandatory fields set in V3 TBScertificate generator");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(this.e);
        aSN1EncodableVector2.add(this.f);
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        if (this.g != null) {
            aSN1EncodableVector.add(this.g);
        } else {
            aSN1EncodableVector.add(new DERSequence());
        }
        aSN1EncodableVector.add(this.h);
        if (this.k != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.k));
        }
        if (this.l != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, this.l));
        }
        if (this.i != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 3, this.i));
        }
        return TBSCertificate.getInstance(new DERSequence(aSN1EncodableVector));
    }
}

