/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x509.TBSCertificateStructure;
import com.enterprisedt.bouncycastle.asn1.x509.Time;
import com.enterprisedt.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class X509CertificateStructure
extends ASN1Object
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    ASN1Sequence a;
    TBSCertificateStructure b;
    AlgorithmIdentifier c;
    DERBitString d;

    public static X509CertificateStructure getInstance(ASN1TaggedObject obj, boolean explicit) {
        return X509CertificateStructure.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static X509CertificateStructure getInstance(Object obj) {
        if (obj instanceof X509CertificateStructure) {
            return (X509CertificateStructure)obj;
        }
        if (obj != null) {
            return new X509CertificateStructure(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public X509CertificateStructure(ASN1Sequence seq) {
        this.a = seq;
        if (seq.size() != 3) {
            throw new IllegalArgumentException("sequence wrong size for a certificate");
        }
        this.b = TBSCertificateStructure.getInstance(seq.getObjectAt(0));
        this.c = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.d = DERBitString.getInstance(seq.getObjectAt(2));
    }

    public TBSCertificateStructure getTBSCertificate() {
        return this.b;
    }

    public int getVersion() {
        return this.b.getVersion();
    }

    public ASN1Integer getSerialNumber() {
        return this.b.getSerialNumber();
    }

    public X500Name getIssuer() {
        return this.b.getIssuer();
    }

    public Time getStartDate() {
        return this.b.getStartDate();
    }

    public Time getEndDate() {
        return this.b.getEndDate();
    }

    public X500Name getSubject() {
        return this.b.getSubject();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.b.getSubjectPublicKeyInfo();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.c;
    }

    public DERBitString getSignature() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

