/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1InputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.DERPrintableString;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;

public abstract class X509NameEntryConverter {
    protected ASN1Primitive convertHexEncoded(String str, int off) throws IOException {
        str = Strings.toLowerCase(str);
        byte[] byArray = new byte[(str.length() - off) / 2];
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            char c2 = str.charAt(i2 * 2 + off);
            char c3 = str.charAt(i2 * 2 + off + 1);
            byArray[i2] = c2 < 'a' ? (byte)(c2 - 48 << 4) : (byte)(c2 - 97 + 10 << 4);
            if (c3 < 'a') {
                int n2 = i2;
                byArray[n2] = (byte)(byArray[n2] | (byte)(c3 - 48));
                continue;
            }
            int n3 = i2;
            byArray[n3] = (byte)(byArray[n3] | (byte)(c3 - 97 + 10));
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        return aSN1InputStream.readObject();
    }

    protected boolean canBePrintable(String str) {
        return DERPrintableString.isPrintableString(str);
    }

    public abstract ASN1Primitive getConvertedValue(ASN1ObjectIdentifier var1, String var2);
}

