/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509.qualified;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.DERPrintableString;

public class Iso4217CurrencyCode
extends ASN1Object
implements ASN1Choice {
    final int a = 3;
    final int b = 1;
    final int c = 999;
    ASN1Encodable d;

    public static Iso4217CurrencyCode getInstance(Object obj) {
        if (obj == null || obj instanceof Iso4217CurrencyCode) {
            return (Iso4217CurrencyCode)obj;
        }
        if (obj instanceof ASN1Integer) {
            ASN1Integer aSN1Integer = ASN1Integer.getInstance(obj);
            int n2 = aSN1Integer.getValue().intValue();
            return new Iso4217CurrencyCode(n2);
        }
        if (obj instanceof DERPrintableString) {
            DERPrintableString dERPrintableString = DERPrintableString.getInstance(obj);
            return new Iso4217CurrencyCode(dERPrintableString.getString());
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public Iso4217CurrencyCode(int numeric) {
        if (numeric > 999 || numeric < 1) {
            throw new IllegalArgumentException("wrong size in numeric code : not in (1..999)");
        }
        this.d = new ASN1Integer(numeric);
    }

    public Iso4217CurrencyCode(String alphabetic) {
        if (alphabetic.length() > 3) {
            throw new IllegalArgumentException("wrong size in alphabetic code : max size is 3");
        }
        this.d = new DERPrintableString(alphabetic);
    }

    public boolean isAlphabetic() {
        return this.d instanceof DERPrintableString;
    }

    public String getAlphabetic() {
        return ((DERPrintableString)this.d).getString();
    }

    public int getNumeric() {
        return ((ASN1Integer)this.d).getValue().intValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.d.toASN1Primitive();
    }
}

