/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509.sigi;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x500.DirectoryString;
import java.util.Enumeration;

public class NameOrPseudonym
extends ASN1Object
implements ASN1Choice {
    private DirectoryString a;
    private DirectoryString b;
    private ASN1Sequence c;

    public static NameOrPseudonym getInstance(Object obj) {
        if (obj == null || obj instanceof NameOrPseudonym) {
            return (NameOrPseudonym)obj;
        }
        if (obj instanceof ASN1String) {
            return new NameOrPseudonym(DirectoryString.getInstance(obj));
        }
        if (obj instanceof ASN1Sequence) {
            return new NameOrPseudonym((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public NameOrPseudonym(DirectoryString pseudonym) {
        this.a = pseudonym;
    }

    private NameOrPseudonym(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        if (!(seq.getObjectAt(0) instanceof ASN1String)) {
            throw new IllegalArgumentException("Bad object encountered: " + seq.getObjectAt(0).getClass());
        }
        this.b = DirectoryString.getInstance(seq.getObjectAt(0));
        this.c = ASN1Sequence.getInstance(seq.getObjectAt(1));
    }

    public NameOrPseudonym(String pseudonym) {
        this(new DirectoryString(pseudonym));
    }

    public NameOrPseudonym(DirectoryString surname, ASN1Sequence givenName) {
        this.b = surname;
        this.c = givenName;
    }

    public DirectoryString getPseudonym() {
        return this.a;
    }

    public DirectoryString getSurname() {
        return this.b;
    }

    public DirectoryString[] getGivenName() {
        DirectoryString[] directoryStringArray = new DirectoryString[this.c.size()];
        int n2 = 0;
        Enumeration enumeration = this.c.getObjects();
        while (enumeration.hasMoreElements()) {
            directoryStringArray[n2++] = DirectoryString.getInstance(enumeration.nextElement());
        }
        return directoryStringArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a != null) {
            return this.a.toASN1Primitive();
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

