/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509.sigi;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERPrintableString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x500.DirectoryString;
import com.enterprisedt.bouncycastle.asn1.x509.sigi.NameOrPseudonym;
import java.math.BigInteger;
import java.util.Enumeration;

public class PersonalData
extends ASN1Object {
    private NameOrPseudonym a;
    private BigInteger b;
    private ASN1GeneralizedTime c;
    private DirectoryString d;
    private String e;
    private DirectoryString f;

    public static PersonalData getInstance(Object obj) {
        if (obj == null || obj instanceof PersonalData) {
            return (PersonalData)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PersonalData((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    private PersonalData(ASN1Sequence seq) {
        if (seq.size() < 1) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration enumeration = seq.getObjects();
        this.a = NameOrPseudonym.getInstance(enumeration.nextElement());
        block7: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement());
            int n2 = aSN1TaggedObject.getTagNo();
            switch (n2) {
                case 0: {
                    this.b = ASN1Integer.getInstance(aSN1TaggedObject, false).getValue();
                    continue block7;
                }
                case 1: {
                    this.c = ASN1GeneralizedTime.getInstance(aSN1TaggedObject, false);
                    continue block7;
                }
                case 2: {
                    this.d = DirectoryString.getInstance(aSN1TaggedObject, true);
                    continue block7;
                }
                case 3: {
                    this.e = DERPrintableString.getInstance(aSN1TaggedObject, false).getString();
                    continue block7;
                }
                case 4: {
                    this.f = DirectoryString.getInstance(aSN1TaggedObject, true);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Bad tag number: " + aSN1TaggedObject.getTagNo());
        }
    }

    public PersonalData(NameOrPseudonym nameOrPseudonym, BigInteger nameDistinguisher, ASN1GeneralizedTime dateOfBirth, DirectoryString placeOfBirth, String gender, DirectoryString postalAddress) {
        this.a = nameOrPseudonym;
        this.c = dateOfBirth;
        this.e = gender;
        this.b = nameDistinguisher;
        this.f = postalAddress;
        this.d = placeOfBirth;
    }

    public NameOrPseudonym getNameOrPseudonym() {
        return this.a;
    }

    public BigInteger getNameDistinguisher() {
        return this.b;
    }

    public ASN1GeneralizedTime getDateOfBirth() {
        return this.c;
    }

    public DirectoryString getPlaceOfBirth() {
        return this.d;
    }

    public String getGender() {
        return this.e;
    }

    public DirectoryString getPostalAddress() {
        return this.f;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, new ASN1Integer(this.b)));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.c));
        }
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, this.d));
        }
        if (this.e != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 3, new DERPrintableString(this.e, true)));
        }
        if (this.f != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 4, this.f));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

