/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x9;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x9.DHValidationParms;
import java.math.BigInteger;
import java.util.Enumeration;

public class DHDomainParameters
extends ASN1Object {
    private ASN1Integer a;
    private ASN1Integer b;
    private ASN1Integer c;
    private ASN1Integer d;
    private DHValidationParms e;

    public static DHDomainParameters getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DHDomainParameters.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static DHDomainParameters getInstance(Object obj) {
        if (obj == null || obj instanceof DHDomainParameters) {
            return (DHDomainParameters)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new DHDomainParameters((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid DHDomainParameters: " + obj.getClass().getName());
    }

    public DHDomainParameters(BigInteger p2, BigInteger g2, BigInteger q2, BigInteger j2, DHValidationParms validationParms) {
        if (p2 == null) {
            throw new IllegalArgumentException("'p' cannot be null");
        }
        if (g2 == null) {
            throw new IllegalArgumentException("'g' cannot be null");
        }
        if (q2 == null) {
            throw new IllegalArgumentException("'q' cannot be null");
        }
        this.a = new ASN1Integer(p2);
        this.b = new ASN1Integer(g2);
        this.c = new ASN1Integer(q2);
        this.d = new ASN1Integer(j2);
        this.e = validationParms;
    }

    public DHDomainParameters(ASN1Integer p2, ASN1Integer g2, ASN1Integer q2, ASN1Integer j2, DHValidationParms validationParms) {
        if (p2 == null) {
            throw new IllegalArgumentException("'p' cannot be null");
        }
        if (g2 == null) {
            throw new IllegalArgumentException("'g' cannot be null");
        }
        if (q2 == null) {
            throw new IllegalArgumentException("'q' cannot be null");
        }
        this.a = p2;
        this.b = g2;
        this.c = q2;
        this.d = j2;
        this.e = validationParms;
    }

    private DHDomainParameters(ASN1Sequence seq) {
        if (seq.size() < 3 || seq.size() > 5) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration enumeration = seq.getObjects();
        this.a = ASN1Integer.getInstance(enumeration.nextElement());
        this.b = ASN1Integer.getInstance(enumeration.nextElement());
        this.c = ASN1Integer.getInstance(enumeration.nextElement());
        ASN1Encodable aSN1Encodable = DHDomainParameters.a(enumeration);
        if (aSN1Encodable != null && aSN1Encodable instanceof ASN1Integer) {
            this.d = ASN1Integer.getInstance(aSN1Encodable);
            aSN1Encodable = DHDomainParameters.a(enumeration);
        }
        if (aSN1Encodable != null) {
            this.e = DHValidationParms.getInstance(aSN1Encodable.toASN1Primitive());
        }
    }

    private static ASN1Encodable a(Enumeration enumeration) {
        return enumeration.hasMoreElements() ? (ASN1Encodable)enumeration.nextElement() : null;
    }

    public ASN1Integer getP() {
        return this.a;
    }

    public ASN1Integer getG() {
        return this.b;
    }

    public ASN1Integer getQ() {
        return this.c;
    }

    public ASN1Integer getJ() {
        return this.d;
    }

    public DHValidationParms getValidationParms() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        if (this.e != null) {
            aSN1EncodableVector.add(this.e);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

