/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x9;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x9.ValidationParams;
import java.math.BigInteger;
import java.util.Enumeration;

public class DomainParameters
extends ASN1Object {
    private final ASN1Integer a;
    private final ASN1Integer b;
    private final ASN1Integer c;
    private final ASN1Integer d;
    private final ValidationParams e;

    public static DomainParameters getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DomainParameters.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static DomainParameters getInstance(Object obj) {
        if (obj instanceof DomainParameters) {
            return (DomainParameters)obj;
        }
        if (obj != null) {
            return new DomainParameters(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public DomainParameters(BigInteger p2, BigInteger g2, BigInteger q2, BigInteger j2, ValidationParams validationParams) {
        if (p2 == null) {
            throw new IllegalArgumentException("'p' cannot be null");
        }
        if (g2 == null) {
            throw new IllegalArgumentException("'g' cannot be null");
        }
        if (q2 == null) {
            throw new IllegalArgumentException("'q' cannot be null");
        }
        this.a = new ASN1Integer(p2);
        this.b = new ASN1Integer(g2);
        this.c = new ASN1Integer(q2);
        this.d = j2 != null ? new ASN1Integer(j2) : null;
        this.e = validationParams;
    }

    private DomainParameters(ASN1Sequence seq) {
        if (seq.size() < 3 || seq.size() > 5) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration enumeration = seq.getObjects();
        this.a = ASN1Integer.getInstance(enumeration.nextElement());
        this.b = ASN1Integer.getInstance(enumeration.nextElement());
        this.c = ASN1Integer.getInstance(enumeration.nextElement());
        ASN1Encodable aSN1Encodable = DomainParameters.a(enumeration);
        if (aSN1Encodable != null && aSN1Encodable instanceof ASN1Integer) {
            this.d = ASN1Integer.getInstance(aSN1Encodable);
            aSN1Encodable = DomainParameters.a(enumeration);
        } else {
            this.d = null;
        }
        this.e = aSN1Encodable != null ? ValidationParams.getInstance(aSN1Encodable.toASN1Primitive()) : null;
    }

    private static ASN1Encodable a(Enumeration enumeration) {
        return enumeration.hasMoreElements() ? (ASN1Encodable)enumeration.nextElement() : null;
    }

    public BigInteger getP() {
        return this.a.getPositiveValue();
    }

    public BigInteger getG() {
        return this.b.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.c.getPositiveValue();
    }

    public BigInteger getJ() {
        if (this.d == null) {
            return null;
        }
        return this.d.getPositiveValue();
    }

    public ValidationParams getValidationParams() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        if (this.e != null) {
            aSN1EncodableVector.add(this.e);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

