/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x9;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x9.KeySpecificInfo;
import java.util.Enumeration;

public class OtherInfo
extends ASN1Object {
    private KeySpecificInfo a;
    private ASN1OctetString b;
    private ASN1OctetString c;

    public OtherInfo(KeySpecificInfo keyInfo, ASN1OctetString partyAInfo, ASN1OctetString suppPubInfo) {
        this.a = keyInfo;
        this.b = partyAInfo;
        this.c = suppPubInfo;
    }

    public static OtherInfo getInstance(Object obj) {
        if (obj instanceof OtherInfo) {
            return (OtherInfo)obj;
        }
        if (obj != null) {
            return new OtherInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private OtherInfo(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.a = KeySpecificInfo.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.b = (ASN1OctetString)aSN1TaggedObject.getObject();
                continue;
            }
            if (aSN1TaggedObject.getTagNo() != 2) continue;
            this.c = (ASN1OctetString)aSN1TaggedObject.getObject();
        }
    }

    public KeySpecificInfo getKeyInfo() {
        return this.a;
    }

    public ASN1OctetString getPartyAInfo() {
        return this.b;
    }

    public ASN1OctetString getSuppPubInfo() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(0, this.b));
        }
        aSN1EncodableVector.add(new DERTaggedObject(2, this.c));
        return new DERSequence(aSN1EncodableVector);
    }
}

