/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x9;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x9.X9FieldElement;
import com.enterprisedt.bouncycastle.asn1.x9.X9FieldID;
import com.enterprisedt.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import java.math.BigInteger;

public class X9Curve
extends ASN1Object
implements X9ObjectIdentifiers {
    private ECCurve a;
    private byte[] b;
    private ASN1ObjectIdentifier c = null;

    public X9Curve(ECCurve curve) {
        this.a = curve;
        this.b = null;
        this.a();
    }

    public X9Curve(ECCurve curve, byte[] seed) {
        this.a = curve;
        this.b = seed;
        this.a();
    }

    public X9Curve(X9FieldID fieldID, ASN1Sequence seq) {
        this(fieldID, null, null, seq);
    }

    public X9Curve(X9FieldID fieldID, BigInteger order, BigInteger cofactor, ASN1Sequence seq) {
        this.c = fieldID.getIdentifier();
        if (this.c.equals(prime_field)) {
            BigInteger bigInteger = ((ASN1Integer)fieldID.getParameters()).getValue();
            BigInteger bigInteger2 = new BigInteger(1, ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
            BigInteger bigInteger3 = new BigInteger(1, ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
            this.a = new ECCurve.Fp(bigInteger, bigInteger2, bigInteger3, order, cofactor);
        } else if (this.c.equals(characteristic_two_field)) {
            Object object;
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(fieldID.getParameters());
            int n2 = ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue().intValue();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(1);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (aSN1ObjectIdentifier.equals(tpBasis)) {
                n3 = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(2)).getValue().intValue();
            } else if (aSN1ObjectIdentifier.equals(ppBasis)) {
                object = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(2));
                n3 = ASN1Integer.getInstance(((ASN1Sequence)object).getObjectAt(0)).getValue().intValue();
                n4 = ASN1Integer.getInstance(((ASN1Sequence)object).getObjectAt(1)).getValue().intValue();
                n5 = ASN1Integer.getInstance(((ASN1Sequence)object).getObjectAt(2)).getValue().intValue();
            } else {
                throw new IllegalArgumentException("This type of EC basis is not implemented");
            }
            object = new BigInteger(1, ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
            BigInteger bigInteger = new BigInteger(1, ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
            this.a = new ECCurve.F2m(n2, n3, n4, n5, (BigInteger)object, bigInteger, order, cofactor);
        } else {
            throw new IllegalArgumentException("This type of ECCurve is not implemented");
        }
        if (seq.size() == 3) {
            this.b = ((DERBitString)seq.getObjectAt(2)).getBytes();
        }
    }

    private void a() {
        if (ECAlgorithms.isFpCurve(this.a)) {
            this.c = prime_field;
        } else if (ECAlgorithms.isF2mCurve(this.a)) {
            this.c = characteristic_two_field;
        } else {
            throw new IllegalArgumentException("This type of ECCurve is not implemented");
        }
    }

    public ECCurve getCurve() {
        return this.a;
    }

    public byte[] getSeed() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.c.equals(prime_field)) {
            aSN1EncodableVector.add(new X9FieldElement(this.a.getA()).toASN1Primitive());
            aSN1EncodableVector.add(new X9FieldElement(this.a.getB()).toASN1Primitive());
        } else if (this.c.equals(characteristic_two_field)) {
            aSN1EncodableVector.add(new X9FieldElement(this.a.getA()).toASN1Primitive());
            aSN1EncodableVector.add(new X9FieldElement(this.a.getB()).toASN1Primitive());
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERBitString(this.b));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

